<?php

class ZlecenieController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','showTempFile','view',
					'import','balance','solutions','ignoreReportedSolution',
					'resetReportedSolution','acceptReportedSolution','solutionsClass',
					'reportedAuctions','resetReportedAuction','ignoreReportedAuction',
					'acceptReportedAuction','addZlecenieAnswer'),
				'roles'=>array('admin')
			),
			array('allow',
				'actions'=>array('solutions','ignoreReportedSolution',
					'resetReportedSolution','acceptReportedSolution','solutionsClass',
					'reportedAuctions','resetReportedAuction','ignoreReportedAuction',
					'acceptReportedAuction'),
				'roles'=>array('schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
		return array(
			'import' => 'application.modules.administration.controllers.zlecenia.ImportAction',
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$model = $this->loadModel($id);
		$answers = array();

		foreach($model->odpowiedziZlecenia as $answer)
			$answers[] = $answer['odpowiedz'];

		$this->render('view', array(
			'model'=>$model,
			'answers'=>$answers
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Zlecenie;
		$orderAnswers = array();

		$model->kara=10;

		if(isset($_POST['Zlecenie']))
		{
			$model->attributes = $_POST['Zlecenie'];

			$model->image = CUploadedFile::getInstance($model,'image');

			//saving image in temporary folder
			if(!empty($model->image))
			{
				if (!file_exists('uploads/temp/'.$model->tempFolderName.'/'))
					mkdir('uploads/temp/'.$model->tempFolderName.'/', 0777, true);

				$model->image->saveAs('uploads/temp/'.$model->tempFolderName.'/'.$model->image->name);
				$model->tempImageName = $model->image->name;
			}

			$modelsValid = true;

			//validating answers
			if(isset($_POST['ZlecenieOdpowiedz']))
			{
				foreach($_POST['ZlecenieOdpowiedz'] as $answer)
				{
					$answerModel = new ZlecenieOdpowiedz;
					$answerModel->attributes = $answer;
					$orderAnswers[] = $answerModel;
					if(!$answerModel->validate())
						$modelsValid = false;
				}
			}

			//validating model + answers
			if($model->validate() && $modelsValid)
			{
				$model->save(false);

				//image exists in temp dir
				if(!empty($model->tempImageName))
					$model->urlObrazka = 'uploads/orders/'.$model->id.'/'.$model->tempImageName;

				$model->save(false);

				//saving answers models
				$ansArr = array();
				foreach($orderAnswers as $answer)
				{
					$answer->idZlecenia = $model->id;
					$answer->save(false);
					$ansArr[] = $answer->odpowiedz;
				}

				//move a photo from the temp directory to a proper one
				if(!empty($model->tempImageName) && !empty($model->tempFolderName))
				{
					if (!file_exists('uploads/orders/'.$model->id))
						mkdir('uploads/orders/'.$model->id, 0777, true);

					copy('uploads/temp/'.$model->tempFolderName.'/'.$model->tempImageName, 'uploads/orders/'.$model->id.'/'.$model->tempImageName);
					unlink('uploads/temp/'.$model->tempFolderName.'/'.$model->tempImageName);
					//removing temp dir and its files
					foreach(scandir('uploads/temp/'.$model->tempFolderName) as $file)
							if(is_file('uploads/temp/'.$model->tempFolderName.'/'.$file))
									unlink('uploads/temp/'.$model->tempFolderName.'/'.$file);
					rmdir('uploads/temp/'.$model->tempFolderName);
				}

				if ($model->moodle)
					GiftWriter::storeTask($model, $ansArr);

				$this->redirect(array('view', 'id'=>$model->id));
			}
		}
		else //at the start - generation unique temp folder name
		{
			$model->tempFolderName = uniqid();
			while(file_exists('uploads/temp/'.$model->tempFolderName))
			{
				$model->tempFolderName = uniqid();
			}
			mkdir('uploads/temp/'.$model->tempFolderName, 0777, true);

			$model->czas = ParametryGry::getValue('CZAS_ROZWIAZYWANIA_ZLECENIA', 60);
		}

		$this->render('create', array(
			'model'=>$model,
			'orderAnswers'=>$orderAnswers
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);
		$orderAnswers = $model->odpowiedziZlecenia;

		if(isset($_POST['Zlecenie']))
		{
			$model->image=CUploadedFile::getInstance($model,'image');

			if(!empty($model->image))
			{
				if(!file_exists('uploads/orders/'.$model->id))
					mkdir('uploads/orders/'.$model->id, 0777, true);

				//cleaning image dir
				foreach(scandir('uploads/orders/'.$model->id) as $file)
						if(is_file('uploads/orders/'.$model->id.'/'.$file))
								unlink('uploads/orders/'.$model->id.'/'.$file);

				$model->urlObrazka = 'uploads/orders/'.$model->id.'/'.$model->image->name;
				$model->image->saveAs('uploads/orders/'.$model->id.'/'.$model->image->name);

				$model->save(false);
			}

			unset($_POST['Zlecenie']['urlObrazka']);
			$model->attributes = $_POST['Zlecenie'];

			$modelsValid = true;

			if(isset($_POST['ZlecenieOdpowiedz']))
			{
				foreach($_POST['ZlecenieOdpowiedz'] as $answer)
				{
					$answerModel = new ZlecenieOdpowiedz;
					$answerModel->attributes = $answer;
					$orderAnswers[] = $answerModel;
					if(!$answerModel->validate())
						$modelsValid = false;
				}
			}

			if($model->validate() && $modelsValid)
			{
				ZlecenieOdpowiedz::model()->deleteAll('"idZlecenia"='.$id);

				$model->save(false);

				$ansArr = array();
				foreach($orderAnswers as $answer)
				{
					$answer->idZlecenia = $model->id;
					$answer->save(false);
					$ansArr[] = $answer->odpowiedz;
				}

				if ($model->moodle)
					GiftWriter::storeTask($model, $ansArr);

				$this->redirect(array('view', 'id'=>$model->id));
			}
		}

		$this->render('update',array(
			'model'=>$model,
			'orderAnswers'=>$orderAnswers
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$this->loadModel($id)->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Zlecenie('search');
		$model->unsetAttributes();

		if(isset($_GET['Zlecenie']))
			$model->attributes = $_GET['Zlecenie'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	public function actionBalance()
	{
		$error = false;

		$criteria = new CDbCriteria;
		$criteria->select = '"nazwa", "wartosc"';
		$criteria->condition = '"nazwa" IN(:parameter1, :parameter2, :parameter3)';
		$criteria->params = array(
			':parameter1'=>'ZLECENIE_CENA_WAGA_LATWE',
			':parameter2'=>'ZLECENIE_CENA_WAGA_SREDNIE',
			':parameter3'=>'ZLECENIE_CENA_WAGA_TRUDNE',
		);
		$criteria->index = 'nazwa';

		$parameters = ParametryGry::model()->findAll($criteria);

		if(isset($_POST['easyWeight'], $_POST['mediumWeight'], $_POST['hardWeight']))
		{
			$easyWeight = $_POST['easyWeight'];
			$mediumWeight = $_POST['mediumWeight'];
			$hardWeight = $_POST['hardWeight'];

			if(!is_numeric($easyWeight) || $easyWeight < 0.1)
				$error = true;
			else if(!is_numeric($mediumWeight) || $mediumWeight < 0.1)
				$error = true;
			else if(!is_numeric($hardWeight) || $hardWeight < 0.1)
				$error = true;

			if(!$error)
			{
				$transaction = Yii::app()->db->beginTransaction();

				try
				{
					//Update parametrów
					$sql = 'UPDATE "ParametryGry" SET "wartosc" = '.$easyWeight.' WHERE "nazwa" = \'ZLECENIE_CENA_WAGA_LATWE\'';
					Yii::app()->db->createCommand($sql)->execute();

					$sql = 'UPDATE "ParametryGry" SET "wartosc" = '.$mediumWeight.' WHERE "nazwa" = \'ZLECENIE_CENA_WAGA_SREDNIE\'';
					Yii::app()->db->createCommand($sql)->execute();

					$sql = 'UPDATE "ParametryGry" SET "wartosc" = '.$hardWeight.' WHERE "nazwa" = \'ZLECENIE_CENA_WAGA_TRUDNE\'';
					Yii::app()->db->createCommand($sql)->execute();

					//Update cene zleceń na podstawie parametrów
					$sql = 'UPDATE "Zlecenie" SET "cena" = "cena" / '.$parameters['ZLECENIE_CENA_WAGA_LATWE']->wartosc.' * '.$easyWeight.' WHERE "poziom" = '.Zlecenie::LEVEL_EASY;
					Yii::app()->db->createCommand($sql)->execute();

					$sql = 'UPDATE "Zlecenie" SET "cena" = "cena" / '.$parameters['ZLECENIE_CENA_WAGA_SREDNIE']->wartosc.' * '.$mediumWeight.' WHERE "poziom" = '.Zlecenie::LEVEL_HARD;
					Yii::app()->db->createCommand($sql)->execute();

					$sql = 'UPDATE "Zlecenie" SET "cena" = "cena" / '.$parameters['ZLECENIE_CENA_WAGA_TRUDNE']->wartosc.' * '.$hardWeight.' WHERE "poziom" = '.Zlecenie::LEVEL_VERY_HARD;
					Yii::app()->db->createCommand($sql)->execute();

					$transaction->commit();
				}
				catch(Exception $e)
				{
					$transaction->rollback();
				}

				Yii::app()->user->setFlash('success', 'Zapisywanie wag zakończone sukcesem.');

				$this->redirect(array('balance'));
			}
		}

		$this->render('balance', array(
			'parameters'=>$parameters,
			'error'=>$error,
		));
	}

	public function actionSolutions()
	{
		$error = false;
		$parameters = false;

		$sql = 'SELECT * FROM "ZlecenieFirmy" WHERE "zgloszone" = 1 ORDER BY "czasZakonczenia" DESC';

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese))
		{
			$sql = 'SELECT * FROM "ZlecenieFirmy" WHERE "zgloszone" = 1 AND "idFirmy" IN ('.implode(',',Yii::app()->user->getState('companies')).') ORDER BY "czasZakonczenia" DESC';
			$zgloszone = ZlecenieFirmy::model()->findAllBySql($sql);
		}
		elseif(Yii::app()->user->role == 'admin')
			$zgloszone = ZlecenieFirmy::model()->findAllBySql($sql);
		elseif(Yii::app()->user->role == 'schoolAdmin' && empty($companiese))
			$zgloszone = array();


//		$sql = 'SELECT * FROM "ZlecenieFirmy" WHERE "czasRozpoczecia" IS NOT NULL AND "czasZakonczenia" IS NOT NULL AND "zgloszone" IS NULL AND "idGrupyPrzetargowej" IS NULL';
		$sql = 'SELECT * FROM "ZlecenieFirmy"
			WHERE "czasRozpoczecia" IS NOT NULL
			AND "czasZakonczenia" IS NOT NULL
			AND "idUcznia" IS NOT NULL
			AND "zgloszone" IS NULL
			AND "idGrupyPrzetargowej" IS NULL';

		$rozwiazane = ZlecenieFirmy::model()->findAllBySql($sql);

		$rozwiazaneBySzkoly = array();

		foreach($rozwiazane as $rozw)
		{
			if(isset($rozw->uczen) && isset($rozw->uczen->klasa) && isset($rozw->uczen->klasa->szkola))
			{
				$idSzkoly = $rozw->uczen->klasa->szkola["id"];
				$nazwaSzkoly = $rozw->uczen->klasa->szkola["nazwa"];
				$rozwiazaneBySzkoly[$idSzkoly][] = array($rozw->uczen->klasa["id"], $rozw->uczen->klasa["nazwa"]);
			}
		}
		//usuniecie duplikatow z tablicy szkola => idKlasy
		$klasySzkoly = array();
		foreach($rozwiazaneBySzkoly as $id=>$klasy)
			$klasySzkoly[$id] = array_map("unserialize", array_unique(array_map("serialize",$klasy)));
//			$szkoly[$nazwa] = array_unique($klasy);

		$nazwySzkol = array();
		foreach($klasySzkoly as $id=>$value)
			$nazwySzkol[$id] = Szkola::model()->findByPk($id)->nazwa;

		$this->render('solutions', array(
			'parameters'=>$parameters,
			'error'=>$error,
			'zgloszone'=>$zgloszone,
			'klasySzkoly'=>$klasySzkoly,
			'nazwySzkol'=>$nazwySzkol,
		));
	}

	public function actionSolutionsClass($id, $companyId = null)
	{
		$klasa = Klasa::model()->findByPk($id);
		if($klasa === null)
			throw new CHttpException(404, 'Wystąpił błąd. Podana klasa nie istnieje w bazie.');

		//przygotowanie wyswietlenia listy firm
		$firmy = array();
		$firmy[null] = 'Wybierz firmę';
		foreach($klasa->firmy as $firma)
		{
			if(count($firma->zlecenieFirmies))
			{
				$nazwa = '';
				if(!empty($firma->nazwa) && $firma->nazwa !== ' ')
					$nazwa .= $firma->nazwa . ': ';

				foreach($firma->activeUsers as $user)
					$nazwa .= $user->imie . ' ' . $user->nazwisko . ', ';
				$nazwa = substr($nazwa, 0, -2);

				$firmy[$firma->id] = $nazwa;
			}
		}
		$findForCompany = false;
		$companyName = ' - wszystkie firmy';
		if($companyId !== null)
		{
			$firma = Firma::model()->findByAttributes(array('id'=>$companyId, 'idKlasy'=>$id));
			if($firma === null)
				throw new CHttpException(404, 'Wystąpił błąd. Podana firma nie istnieje w bazie lub jest powiązana z inną klasą.');

			$companyName = ' - firma ' . $firmy[$companyId];
			$findForCompany = true;
		}

		$sql = 'SELECT "id" FROM "Uzytkownik" WHERE "idKlasy" = '. $id;
		if($findForCompany)
			$sql = 'SELECT "id" FROM "Uzytkownik" WHERE "idKlasy" = '. $id . ' AND "idFirmy" = ' . $companyId;
		$userIds = Yii::app()->db->createCommand($sql)->queryColumn();

		$c = new CDbCriteria();
		$c->addInCondition('"t"."idUcznia"', $userIds);
		//$c->addCondition('"t"."czasRozpoczecia" IS NOT NULL AND "t"."czasZakonczenia" IS NOT NULL AND "t"."zgloszone" IS NULL');
		$c->addCondition('"t"."czasZakonczenia" IS NOT NULL AND "t"."zgloszone" IS NULL AND "idGrupyPrzetargowej" IS NULL');
		$c->order = '"t"."czasZakonczenia" DESC';
		$zlecenia = ZlecenieFirmy::model()->findAll($c);

		$this->render('solutionsClass', array(
			'zlecenia'=>$zlecenia,
			'klasa'=>$klasa,
			'firmy'=>$firmy,
			'companyName' => $companyName,
		));
	}

	public function actionIgnoreReportedSolution($id)
	{
		$zlecenie = ZlecenieFirmy::model()->findByPk($id);
		if($zlecenie === null)
			throw new CHttpException(404, 'Wystąpił błąd. Nie ma takiego zlecenia.');

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($zlecenie->idFirmy, Yii::app()->user->getState('companies')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$zlecenie->zgloszone = null;
		$zlecenie->save(false);

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie odrzucono";
		$message = 'Witaj, zgłosiłeś/aś do nas rozwiązanie zlecenia z kategorii '. $zlecenie->idZlecenia0->kategoria;
		$message .= '. Treść zadania: '. $zlecenie->idZlecenia0->tresc;
		$message .= '. Twoja odpowiedź: '. $zlecenie->odpowiedz;
		$message .= '. Decyzja: odwołanie odrzucono.';
		$to = $zlecenie->uczen->email;
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('solutions'));
	}

	public function actionAcceptReportedSolution($id)
	{
		$zlecenieFirmy = ZlecenieFirmy::model()->findByPk($id);
		if($zlecenieFirmy === null)
			throw new CHttpException(404, 'Wystąpił błąd. Nie ma takiego zlecenia.');

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($zlecenieFirmy->idFirmy, Yii::app()->user->getState('companies')) )
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			//automatycznie dopisz odpowiedz
			$odp = new ZlecenieOdpowiedz();
			$odp->idZlecenia = $zlecenieFirmy->idZlecenia;
			$odp->odpowiedz = $zlecenieFirmy->odpowiedz;
			$odp->save(false);

			//usuniecie oplat zwiazanych z blednym rozwiazaniem
			$idOplaty = $zlecenieFirmy->idOplaty;
			$nextIdOplaty = (int)$idOplaty + 1;
			$oplaty = Oplaty::model()->findAllByPk(array($idOplaty, $nextIdOplaty));

			//zwrot z oplat
			$zwrot = 0;
			$wartosc = 0;
			foreach($oplaty as $oplata)
			{
				$wartosc = str_replace(',', '.', $oplata->wartosc);
				$zwrot += abs((float)$wartosc);
				$oplata->delete();
			}

			$firma = Firma::model()->findByPk($zlecenieFirmy->idFirmy);
			$stanKonta = (float)$firma->stanKonta;
			$firma->stanKonta = $stanKonta + (float)$zwrot;
			$firma->save(false);

			$zlecenieFirmy->idOdpowiedzi = $odp->id;
			$zlecenieFirmy->odpowiedz = $odp->odpowiedz;
			$zlecenieFirmy->zgloszone = null;
			$zlecenieFirmy->idFaktury = null;

			//oplaty i faktury
			$faktura = new Faktury;
			$faktura->czyKoszt = 0;
			$faktura->idFirmy = $zlecenieFirmy->idFirmy;
			$faktura->idKontrahenta = $zlecenieFirmy->idKontrahenta;
			$faktura->dataWystawienia = new CDbExpression('SYSDATE');
			$faktura->opis = 'Wykonanie zlecenia z ' . $zlecenieFirmy->idZlecenia0->dziedzina->nazwa
				. ' poziom ' . strtolower($zlecenieFirmy->idZlecenia0->poziomStr);
			$faktura->nrFaktury = 'F/' . date('Y/m/d/', time()) . rand(0, 9) . rand(0, 9) . rand(0, 9);
			$faktura->stawkaVat = ParametryGry::getFloat('PODATEK_VAT', 0.23);
			$faktura->cenaNetto = $zlecenieFirmy->idZlecenia0->cena;
			$faktura->dataPlatnosci = new CDbExpression('SYSDATE');
			$faktura->save(false);
			$zlecenieFirmy->idFaktury = $faktura->id;

			$przelew = new Oplaty;
			$przelew->rodzajOplaty = Oplaty::TYPE_TASK_PAYMENT;
			$przelew->idFirmy = $zlecenieFirmy->idFirmy;
			$przelew->idKontrahenta = $zlecenieFirmy->idKontrahenta;
			$przelew->tytul = 'Opłata za fakturę ' . $faktura->nrFaktury;
			$przelew->wartosc = $faktura->cenaBrutto;
			$przelew->czas = new CDbExpression('SYSDATE');
			$przelew->save(false);
			$zlecenieFirmy->idOplaty = $przelew->id;

			$zlecenieFirmy->idFirmy0->stanKonta = (float)$zlecenieFirmy->idFirmy0->stanKonta + (float)$przelew->wartosc;
			$zlecenieFirmy->idFirmy0->save(false);

			$zlecenieFirmy->save(false);

			$transaction->commit();
		}
		catch(Exception $e)
		{
			$transaction->rollback();
		}

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie zaakceptowano";
		$message = 'Witaj, zgłosiłeś/aś do nas rozwiązanie zlecenia z kategorii '. $zlecenieFirmy->idZlecenia0->kategoria;
		$message .= '. Treść zadania: '. $zlecenieFirmy->idZlecenia0->tresc;
		$message .= '. Twoja odpowiedź: '. $zlecenieFirmy->odpowiedz;
		$message .= '. Decyzja: odwołanie zaakceptowano.';
		$to = $zlecenieFirmy->uczen->email;
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('solutions'));
	}

	public function actionResetReportedSolution($id)
	{
		$zlecenieFirmy = ZlecenieFirmy::model()->findByPk($id);
		if($zlecenieFirmy === null)
			throw new CHttpException(404, 'Wystąpił błąd. Nie ma takiego zlecenia.');

		$companiese = Yii::app()->user->getState('companies');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($companiese) && !in_array($zlecenieFirmy->idFirmy, Yii::app()->user->getState('companies')) )
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			//oplaty
			$idOplaty = $zlecenieFirmy->idOplaty;

			$zlecenieFirmy->czasRozpoczecia = null;
			$zlecenieFirmy->czasZakonczenia = null;

			// na wypadek gdyby minęło zbyt wiele dni od zgłoszenia resetujemy czas na rozwiązanie
			$zlecenieFirmy->czasPodjecia = new CDbExpression('SYSDATE');
			$zlecenieFirmy->czasPrzypisania = new CDbExpression('SYSDATE');

			//usuniecie faktury przypisanej do zlecenia
			$idFaktury = $zlecenieFirmy->idFaktury;
			$faktura = Faktury::model()->findByPk($idFaktury);
			if(!empty($faktura)) $faktura->delete();

			$zlecenieFirmy->idFaktury = null;
			$zlecenieFirmy->odpowiedz = null;
			$zlecenieFirmy->idOdpowiedzi = null;
			$zlecenieFirmy->idOplaty = null;
			$zlecenieFirmy->zgloszone = null;
			$zlecenieFirmy->save(false);

			$nextIdOplaty = (int)$idOplaty + 1;
			$oplaty = Oplaty::model()->findAllByPk(array($idOplaty, $nextIdOplaty));

			$zwrot = 0;
			$wartosc = 0;
			foreach($oplaty as $oplata)
			{
				$wartosc = str_replace(',', '.', $wartosc);
				$zwrot += abs((float)$oplata->wartosc);
				$oplata->delete();
			}

			$firma = Firma::model()->findByPk($zlecenieFirmy->idFirmy);

			$stanKonta = (float)$firma->stanKonta;
			$firma->stanKonta = (float)$stanKonta + (float)$zwrot;
			$firma->save(false);

			$transaction->commit();
		}
		catch(Exception $e)
		{
			$transaction->rollback();
		}

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwolawczej - zadanie zresetowano do ponownego rozwiazania";
		$message = 'Witaj, zgłosiłeś/aś do nas rozwiązanie zlecenia z kategorii '. $zlecenieFirmy->idZlecenia0->kategoria;
		$message .= '. Treść zadania: '. $zlecenieFirmy->idZlecenia0->tresc;
		$message .= '. Twoja odpowiedź: '. $zlecenieFirmy->odpowiedz;
		$message .= '. Decyzja: zadanie zresetowano do ponownego rozwiązania.';
		$to = $zlecenieFirmy->uczen->email;
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('solutions'));

	}

	public function actionReportedAuctions()
	{
		$condition = '"t"."zgloszone" IS NOT NULL';

		$tenderse = Yii::app()->user->getState('tenders');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($tenderse))
			$condition = '"t"."zgloszone" IS NOT NULL AND "t"."id" IN ('.implode(',', Yii::app()->user->getState('tenders')).')';
		elseif(Yii::app()->user->role == 'schoolAdmin' && empty($tenderse))
			$condition = null;
		
		if($condition !== null)
			$przetargi = PrzetargGrupa::model()->findAll(array(
				'condition'=>$condition,
			));
		else
			$przetargi = array();

		// $przetargi = PrzetargGrupa::model()->findAll(array(
		// 		'condition'=>'"t"."status" = 5',
		// 		));

		$this->render('reportedAuctions', array(
			'przetargi' => $przetargi,
		));
	}

	public function actionIgnoreReportedAuction($id)
	{
		$przetarg = PrzetargGrupa::model()->findByPk($id);
		if($przetarg === null)
			throw new CHttpException(404, 'Wystąpił błąd. Nie ma takiego przetargu.');

		$tenderse = Yii::app()->user->getState('tenders');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($tenderse) && !in_array($przetarg->id, Yii::app()->user->getState('tenders')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$poziomy = array(
			Zlecenie::LEVEL_EASY => 'Łatwe',
			Zlecenie::LEVEL_HARD => 'Trudne',
			Zlecenie::LEVEL_VERY_HARD => 'Bardzo trudne',
		);

		$emails = array();
		foreach($przetarg->activeCompanies as $company)
			foreach($company->activeUsers as $user)
				$emails[] = $user->email;

		$przetarg->zgloszone = null;
		$przetarg->save(false);

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie odrzucono";
		$message = 'Witaj, zgłoszono do nas następujący przetarg od firmy '. $przetarg->przetarg->kontrahent->nazwa .' z dziedziny '. $przetarg->przetarg->poziomTrudnosci . ' (' . $poziomy[$przetarg->przetarg->poziomTrudnosci] .').' ;
		$to = implode(", ",$emails);
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('reportedAuctions'));
	}

	public function actionResetReportedAuction($id)
	{
		$przetarg = PrzetargGrupa::model()->findByPk($id);
		if($przetarg === null)
			throw new CHttpException(404, 'Wystąpił błąd. Nie ma takiego przetargu.');

		$tenderse = Yii::app()->user->getState('tenders');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($tenderse) && !in_array($przetarg->id, Yii::app()->user->getState('tenders')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$emails = array();
		foreach($przetarg->activeCompanies as $company)
			foreach($company->activeUsers as $user)
				$emails[] = $user->email;

		$zwrotOplaty = 0;

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			//usuniecie starych zlecen (pozniej losujemy nowe)
			$idsOplaty = array();
			foreach($przetarg->tasks as $zlecenie)
			{
				if(!in_array($zlecenie->idOplaty, $idsOplaty)) $idsOplaty[] = $zlecenie->idOplaty;
				$zlecenie->delete();
			}

			//usuniecie oplat
			foreach($idsOplaty as $idOplaty)
			{
				$oplata = Oplaty::model()->findByPk($idOplaty);
				$zwrotOplaty += (float)abs($oplata->wartosc);
				$oplata->delete();
			}

			//oblicz liczbe zlecen do wylosowania
			$tasksCount = 0;
			foreach ($przetarg->activeCompanies as $company)
			{
				$userCount = count($company->activeUsers);
				$multiplay = 1;

				if ($przetarg->przetarg->kontrahent->idDziedziny == $company->idDziedziny)
					$multiplay = 3;
				else if ($userCount == 1)
					$multiplay = 2;

				$tasksCount += $multiplay * $userCount;
			}

			$minTasksCount = (int)ParametryGry::getValue('PRZETARG_MIN_ILOSC_ZADAN', 4);

			if($tasksCount < $minTasksCount)
				$tasksCount = $minTasksCount;

			//wylosuj zlecenia
			$tasks = Yii::app()->db->createCommand('
				select * from (
					select z."id" from "Zlecenie" z
					where z."czyPrzetarg" > 0 and z."idDziedziny" = :idDziedziny and z."poziom" = :lvl and (z."wylaczone" is null or z."wylaczone" != 1)
					ORDER BY dbms_random.value
				) where ROWNUM <= :max
			')->queryAll(true, array(
				':lvl' => $przetarg->przetarg->poziomTrudnosci,
				':idDziedziny' => $przetarg->przetarg->kontrahent->idDziedziny,
				':max' => $tasksCount
			));

			//dodaj zlecenia
			foreach ($tasks as $randomTask)
			{
				$task = new ZlecenieFirmy;
				$task->idZlecenia = $randomTask['id'];
				$task->idKontrahenta = $przetarg->przetarg->idKontrahenta;
				$task->czasPodjecia = new CDbExpression('SYSDATE');
				//$task->czasPrzypisania = new CDbExpression('SYSDATE');
				$task->idGrupyPrzetargowej = $przetarg->id;
				$task->save(false);
			}

			//zwrot kar za niewykonany przetarg
			foreach ($przetarg->activeCompanies as $company)
			{
				$company->stanKonta = (float)$company->stanKonta + (float)$zwrotOplaty / count($przetarg->activeCompanies);
				$company->save(false);
			}

			$przetarg->status = PrzetargGrupa::TENDER_STATUS_ACCEPTED;
			$przetarg->zgloszone = null;
			$przetarg->save(false);

			$transaction->commit();
		}
		catch(Exception $e)
		{
			$transaction->rollback();
		}

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie zaakceptowano";
		$message = 'Witaj, zgłoszono do nas następujący przetarg od firmy '. $przetarg->przetarg->kontrahent->nazwa .'. Przetarg został zaakceptowany, na konto Waszej firmy wpłynęło wynagrodzenie za wykonane zlecenia.' ;
		$to = implode(", ",$emails);
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('reportedAuctions'));
	}

	public function actionAcceptReportedAuction($id)
	{
		$przetarg = PrzetargGrupa::model()->findByPk($id);
		if($przetarg === null)
			throw new CHttpException(404, 'Wystąpił błąd. Nie ma takiego przetargu.');

		$tenderse = Yii::app()->user->getState('tenders');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($tenderse) && !in_array($przetarg->id, Yii::app()->user->getState('tenders')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		$zlecenia = $przetarg->tasks;

		$emails = array();
		foreach($przetarg->activeCompanies as $company)
			foreach($company->activeUsers as $user)
				$emails[] = $user->email;

		$this->acceptTender($id);

		//wyslanie maila z informacja
		$subject = "Decyzja Komisji odwoławczej - odwołanie zaakceptowano";
		$message = 'Witaj, zgłoszono do nas następujący przetarg od firmy '. $przetarg->przetarg->kontrahent->nazwa .'. Przetarg został zaakceptowany, na konto Waszej firmy wpłynęło wynagrodzenie za wykonane zlecenia.' ;
		$to = implode(", ",$emails);
		$headers = 'From: info@kreatywnie.lublin.eu' . "\r\n" .
			'Reply-To: info@kreatywnie.lublin.eu' . "\r\n" .
			'X-Mailer: PHP/' . phpversion();

		mail($to, $subject, $message, $headers);

		$this->redirect(array('reportedAuctions'));
	}

	public function actionAddZlecenieAnswer()
	{
		header('Content-type: text/json');
		$result = array();

		if(isset($_POST['zlecenieId']) && !empty($_POST['zlecenieId']))
		{
			$zlecenieId = filter_input(INPUT_POST, 'zlecenieId', FILTER_VALIDATE_INT);
			$zlecenie = ZlecenieFirmy::model()->findByPk($zlecenieId);
			if($zlecenie !== null)
			{
				$odp = new ZlecenieOdpowiedz();
				$odp->idZlecenia = $zlecenie->idZlecenia;
				$odp->odpowiedz = $zlecenie->odpowiedz;
				$odp->save(false);

				$zlecenie->idOdpowiedzi = $odp->id;
				$zlecenie->save(false);

				$result['odpowiedz'] = $zlecenie->odpowiedz;

				//sprawdzenie statusu
				$status = Yii::app()->db->createCommand('
					select
						sum(case when zf."czasZakonczenia" is not null and zf."czasRozpoczecia" is not null and zf."idOdpowiedzi" is not null then 1 else 0 end) "success",
						sum(case when zf."idOdpowiedzi" is null then 1 else 0 end) "failed"
					from "ZlecenieFirmy" zf where zf."idGrupyPrzetargowej" = :grupaId
				')->queryRow(true, array(':grupaId'=>$zlecenie->tenderGroup->id));

				$tenderFailedTasksLimit = (int)ParametryGry::getValue('PRZETARG_MAX_ZLE_ROZWIAZANYCH_ZADAN', 1) * count($zlecenie->tenderGroup->firmy);

				$result['odpowiedz'] = $zlecenie->odpowiedz;

				if ((int)$status['failed'] <= $tenderFailedTasksLimit && (((int)$status['failed'] + (int)$status['success']) == $zlecenie->tenderGroup->tasksCount) && $zlecenie->tenderGroup->status !== PrzetargGrupa::TENDER_STATUS_SUCCESS)
				{
					$this->acceptTender($zlecenie->tenderGroup->id);
					$result['tenderCompleted'] = true;
				}
//				else if ((int)$status['failed'] && (int)$status['failed'] > $tenderFailedTasksLimit)
				else
					$result['tenderCompleted'] = false;
			}
			else
			{
				$result['odpowiedz'] = null;
				$result['tenderCompleted'] = null;
			}
		}

		echo json_encode($result);
		Yii::app()->end();
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Zlecenie::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		return $model;
	}

	private function acceptTender($id)
	{
		$przetarg = PrzetargGrupa::model()->findByPk($id);
		$zlecenia = $przetarg->tasks;

		$tenderFailedTasksLimit = (int)ParametryGry::getValue('PRZETARG_MAX_ZLE_ROZWIAZANYCH_ZADAN', 1) * count($przetarg->firmy);
		$value = (float)$przetarg->oferowanaCena / count($przetarg->activeCompanies);
		$zwrotOplaty = 0;

		$transaction = Yii::app()->db->beginTransaction();
		try
		{
			//pobranie zlecen w celu znalezienia idOplaty
			$idsOplaty = array();
			foreach($zlecenia as $zlecenie)
				if(!in_array($zlecenie->idOplaty, $idsOplaty)) $idsOplaty[] = $zlecenie->idOplaty;

			//usuniecie oplat
			foreach($idsOplaty as $idOplaty)
			{
				$oplata = Oplaty::model()->findByPk($idOplaty);
				$zwrotOplaty += (float)abs($oplata->wartosc);
				$oplata->delete();
			}

			//wystawienie faktur dla firm
			$tenderPartialPayment = (int)ParametryGry::getValue('PRZETARG_OPLATA_CZASTKOWA', 1);
			if ($tenderPartialPayment)
			{
				$value /= (int)$przetarg->tasksCount;
				$description = 'Cząstkowa opłata za przetarg ' . $przetarg->przetarg->kontrahent->dziedzina->nazwa
					. ' - ' . $przetarg->przetarg->poziomStr . ' dla ' . $przetarg->przetarg->kontrahent->nazwa . '.';
			}
			else
			{
				$description = 'Wykonanie przetargu ' . $przetarg->przetarg->kontrahent->dziedzina->nazwa
					. ' - ' . $przetarg->przetarg->poziomStr . ' dla ' . $przetarg->przetarg->kontrahent->nazwa;

				$penaltyValue = 0;
				foreach($przetarg->failedTasks as $failedTask)
				{
					$penaltyValue += $failedTask->idZlecenia0->kara/100 * $value/(int)$przetarg->tasksCount;
				}
				$value -= $penaltyValue;
			}

			foreach ($przetarg->activeCompanies as $company)
			{
				$faktura = new Faktury;
				$faktura->czyKoszt = 0;
				$faktura->idFirmy = $company->id;
				$faktura->idKontrahenta = $przetarg->przetarg->idKontrahenta;
				$faktura->dataWystawienia = new CDbExpression('SYSDATE');
				$faktura->opis = $description;
				$faktura->nrFaktury = 'F/' . date('Y/m/d/', time()) . rand(0, 9) . rand(0, 9) . rand(0, 9);
				$faktura->stawkaVat = ParametryGry::getFloat('PODATEK_VAT', 0.23);
				$faktura->cenaNetto = $value;
				$faktura->dataPlatnosci = new CDbExpression('SYSDATE');
				$faktura->save(false);

				$przelew = new Oplaty;
				$przelew->rodzajOplaty = Oplaty::TYPE_TASK_PAYMENT;
				$przelew->idFirmy = $company->id;
				$przelew->idKontrahenta = $przetarg->przetarg->idKontrahenta;
				$przelew->tytul = 'Opłata za fakturę ' . $faktura->nrFaktury;
				$przelew->wartosc = $faktura->cenaBrutto;
				$przelew->czas = new CDbExpression('SYSDATE');
				$przelew->save(false);

				$company->stanKonta = (float)$company->stanKonta + (float)$przelew->wartosc + (float)$zwrotOplaty / count($przetarg->activeCompanies);
				$company->save(false);
			}

			$przetarg->status = PrzetargGrupa::TENDER_STATUS_SUCCESS;
			$przetarg->zgloszone = null;
			$przetarg->save(false);

			$transaction->commit();
		}
		catch(Exception $e)
		{
			$transaction->rollback();
		}
	}
}
